% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/old_taxa--taxonomy--docs.R
\name{subtaxa}
\alias{subtaxa}
\title{Get subtaxa}
\arguments{
\item{obj}{The [taxonomy()] or [taxmap()] object containing taxon
information to be queried.}

\item{subset}{Taxon IDs, TRUE/FALSE vector, or taxon indexes to find subtaxa for.
Default: All taxa in `obj` will be used. Any variable name that appears in
[all_names()] can be used as if it was a vector on its own.}

\item{recursive}{(`logical` or `numeric`) If `FALSE`, only return the subtaxa
one rank below the target taxa. If `TRUE`, return all the subtaxa of every
subtaxa, etc. Positive numbers indicate the number of ranks below the
immediate subtaxa to return. `1` is equivalent to `FALSE`. Negative numbers
are equivalent to `TRUE`. Since the algorithm is optimized for traversing
all of large trees, `numeric` values greater than 0 for this option
actually take slightly longer to compute than either TRUE or FALSE.}

\item{simplify}{(`logical`) If `TRUE`, then combine all the results
into a single vector of unique values.}

\item{include_input}{(`logical`) If `TRUE`, the input taxa are
included in the output}

\item{value}{What data to return. This is usually the name of column in a
table in `obj$data`. Any result of [all_names()] can be used, but it
usually only makes sense to data that corresponds to taxa 1:1, such as
[taxon_ranks()]. By default, taxon indexes are returned.}
}
\value{
If `simplify = FALSE`, then a list of vectors are returned
  corresponding to the `target` argument. If `simplify = TRUE`,
  then the unique values are returned in a single vector.
}
\description{
Return data for the subtaxa of each taxon in an [taxonomy()] or [taxmap()]
object.
\preformatted{
obj$subtaxa(subset = NULL, recursive = TRUE,
  simplify = FALSE, include_input = FALSE, value = "taxon_indexes")
subtaxa(obj, subset = NULL, recursive = TRUE,
  simplify = FALSE, include_input = FALSE, value = "taxon_indexes")}
}
\examples{
# return the indexes for subtaxa for each taxon
subtaxa(ex_taxmap)

# Only return data for some taxa using taxon indexes
subtaxa(ex_taxmap, subset = 1:3)

# Only return data for some taxa using taxon ids
subtaxa(ex_taxmap, subset = c("d", "e"))

# Only return data for some taxa using logical tests
subtaxa(ex_taxmap, subset = taxon_ranks == "genus")

# Only return subtaxa one level below
subtaxa(ex_taxmap, recursive = FALSE)

# Only return subtaxa some number of ranks below
subtaxa(ex_taxmap, recursive = 2)

# Return something besides taxon indexes
subtaxa(ex_taxmap, value = "taxon_names")
}
\seealso{
Other taxonomy indexing functions: 
\code{\link{branches}()},
\code{\link{internodes}()},
\code{\link{leaves}()},
\code{\link{roots}()},
\code{\link{stems}()},
\code{\link{supertaxa}()}
}
\concept{taxonomy indexing functions}
