% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/old_taxa--taxonomy--docs.R
\name{get_data_frame}
\alias{get_data_frame}
\title{Get data in a taxonomy or taxmap object by name}
\arguments{
\item{obj}{A [taxonomy()] or [taxmap()]  object}

\item{name}{(`character`) Names of data to return. If not supplied, return
all data listed in [all_names()].}

\item{...}{Passed to [all_names()]. Used to filter what kind of data is
returned (e.g. columns in tables or function output?) if `name` is not
supplied or what kinds are allowed if `name` is supplied.}
}
\value{
`data.frame`
}
\description{
Given a vector of names, return a  table of the indicated data
contained in a [taxonomy()] or [taxmap()] object.
\preformatted{
obj$get_data_frame(name = NULL, ...)
get_data_frame(obj, name = NULL, ...)}
}
\details{
Note: This function will not work with variables in datasets in [taxmap()]
objects unless their rows correspond 1:1 with all taxa.
}
\examples{
# Get specific values
get_data_frame(ex_taxmap, c("taxon_names", "taxon_indexes", "is_stem"))


}
\concept{accessors}
