% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/old_taxa--taxonomy--docs.R
\name{all_names}
\alias{all_names}
\title{Return names of data in [taxonomy()] or [taxmap()]}
\arguments{
\item{obj}{([taxonomy()] or [taxmap()]) The object containing
taxon information to be queried.}

\item{tables}{This option only applies to [taxmap()] objects. If `TRUE`,
include the names of columns of tables in `obj$data`}

\item{funcs}{This option only applies to [taxmap()] objects. If `TRUE`,
include the names of user-definable functions in `obj$funcs`.}

\item{others}{This option only applies to [taxmap()] objects. If `TRUE`,
include the names of data in `obj$data` besides tables.}

\item{builtin_funcs}{This option only applies to [taxmap()] objects. If
`TRUE`, include functions like [n_supertaxa()] that provide information for
each taxon.}

\item{warn}{option only applies to [taxmap()] objects. If `TRUE`, warn if
there are duplicate names. Duplicate names make it unclear what data is
being referred to.}
}
\value{
`character`
}
\description{
Return the names of data that can be used with functions in the taxa
package that use [non-standard evaluation](http://adv-r.had.co.nz/Computing-on-the-language.html) (NSE),
like [filter_taxa()].
\preformatted{
obj$all_names(tables = TRUE, funcs = TRUE,
  others = TRUE, warn = FALSE)
all_names(obj, tables = TRUE, funcs = TRUE,
  others = TRUE, warn = FALSE)}
}
\examples{
# Get the names of all data accesible by non-standard evaluation
all_names(ex_taxmap)

# Dont include the names of automatically included functions.
all_names(ex_taxmap, builtin_funcs = FALSE)

}
\seealso{
Other NSE helpers: 
\code{\link{data_used}},
\code{\link{get_data}()},
\code{\link{names_used}}
}
\concept{NSE helpers}
