% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Unary.R
\name{svd_byname}
\alias{svd_byname}
\title{Calculate the singular value decomposition of a matrix}
\usage{
svd_byname(a, which = c("d", "u", "v"))
}
\arguments{
\item{a}{A matrix to be decomposed.}

\item{which}{The matrix to be returned. Default is "d". See details.}
}
\value{
A matrix of the singular value decomposition of \code{a}.
}
\description{
The singular value decomposition decomposes matrix \strong{A} into
\strong{A} = \strong{U} \strong{D} \strong{V}^T,
where \strong{U} and \strong{V} are orthogonal matrices and \strong{D} is a diagonal matrix.
\strong{U} is the left singular vectors of \strong{A}.
\strong{V} is the right singular vectors of \strong{A}.
}
\details{
\code{which} determines the part of the singular value decomposition to be returned.
"d" (default) gives the \strong{D} matrix.
"u" gives the \strong{U} matrix.
"v" gives the \strong{V} matrix (not its transpose).
}
\examples{
A = matrix(c(4, 0, 
             3, -5), nrow = 2, ncol = 2, byrow = TRUE, 
           dimnames = list(c("r1", "r2"), c("c1", "c2"))) \%>\% 
  setrowtype("Product") \%>\% setcoltype("Industry")
A
svd_byname(A) # Gives D matrix, by default
svd_byname(A, which = "d")
svd_byname(A, which = "u")
svd_byname(A, which = "v")
}
