% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrixprofiler-package.R
\name{matrixprofiler}
\alias{matrixprofiler}
\title{Matrix Profile for R}
\description{
This package is derived from the former package \code{tsmp}. It is intended to make a clear separation of what is the
Matrix Profile computation and what are the data mining process we can do using Matrix Profile.
}
\details{
The Matrix Profile, has the potential to revolutionize time series data mining because of its generality,
versatility, simplicity and scalability. In particular it has implications for time series motif discovery, time
series joins, shapelet discovery (classification), density estimation, semantic segmentation, visualization, rule
discovery, clustering etc.
}
\section{Parallel backend}{
This package uses RcppParallel in order to do multithreading computations. By default it uses the 'TBB' backend.
If por any reason you want to change the backend to 'tinythread', you may use:
\code{Sys.setenv(RCPP_PARALLEL_BACKEND = "tinythread")}. To configure back to 'TBB', use
\code{Sys.setenv(RCPP_PARALLEL_BACKEND = "tbb")}.
}

\references{
\itemize{
\item Yeh CCM, Zhu Y, Ulanova L, Begum N, Ding Y, Dau HA, et al. Matrix profile I: All pairs similarity joins
for time series: A unifying view that includes motifs, discords and shapelets. Proc - IEEE Int Conf Data Mining,
ICDM. 2017;1317-22.
}

\itemize{
\item Zhu Y, Imamura m, Nikovski D, Keogh E. Matrix Profile VII: Time Series Chains: A New Primitive for Time
Series Data Mining. Knowl Inf Syst. 2018 Jun 2;1-27.
}

\itemize{
\item Zhu Y, Zimmerman Z, Senobari NS, Yeh CM, Funning G. Matrix Profile II : Exploiting a Novel Algorithm
and GPUs to Break the One Hundred Million Barrier for Time Series Motifs and Joins. Icdm. 2016 Jan 22;54(1):739-48.
}

Website: \url{http://www.cs.ucr.edu/~eamonn/MatrixProfile.html}
}
