% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/custom_stan_code_functions.R
\name{create_stan_file}
\alias{create_stan_file}
\title{Create a "skeleton" for custom Stan code}
\usage{
create_stan_file(save = FALSE, location = "")
}
\arguments{
\item{save}{To confirm that files can be saved (default FALSE).}

\item{location}{Path to location.}
}
\value{
Nothing.
}
\description{
Makes and saves files with generic code
for writing custom Stan code and still use the HD prior.
}
\details{
Must be in an interactive session to store the code.
A folder called \code{"my_stan_code"} will be created in \code{location}.
If the folder already exists in the
specified location, you get an error. The folder contains:
\describe{
  \item{\code{main_file.stan}}{Main file. Can put all necessary functions here, but for a cleaner code
  that is easier to read, we put the functions in separate files.}
  \item{\code{jacobian.stan}}{Function that automatically computes the Jacobian, needed
  to transform from weights and total variance parameterization to log-variance parameterization.}
  \item{\code{prior_distributions.stan}}{Functions for computing the prior distributions.}
}
The provided code is written so a random intercept model with an intercept, a group effect and
a residual effect can be fitted:
\describe{
  \item{\code{example_custom_stan.R}}{R script showing how one can fit a random intercept model using the provided code.}
}
The code can be expanded to fit the desired model.
This requires some knowledge about Stan.
No more documentation is given, as this is merely an offer to users who want to use other models than
what are provided in the package already, and will be highly model specific.
}
\examples{
\dontrun{
create_stan_file(TRUE, "")
}

}
