% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_glyphs.R
\name{l_glyph_add_pointrange}
\alias{l_glyph_add_pointrange}
\title{Add a Pointrange Glyph}
\usage{
l_glyph_add_pointrange(widget, ymin, ymax, linewidth = 1, label = "",
  ...)
}
\arguments{
\item{widget}{widget path as a string or as an object handle}

\item{ymin}{vector with lower y-yalue of the point range.}

\item{ymax}{vector with upper y-yalue of the point range.}

\item{linewidth}{line with in pixel.}

\item{label}{label of a glyph (currently shown only in the glyph inspector)}

\item{...}{state arguments}
}
\description{
Pointrange glyphs show a filled circle at the x-y location and
  also a y-range.
}
\examples{
p <- l_plot(x = 1:3, color = c('red', 'blue', 'green'), showScales=TRUE)
g <- l_glyph_add_pointrange(p, ymin=(1:3)-(1:3)/5, ymax=(1:3)+(1:3)/5)
p['glyph'] <- g
}
\seealso{
\code{\link{l_glyph_add}}
}
