% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_context2d.R
\name{l_context_add_geodesic2d}
\alias{l_context_add_geodesic2d}
\title{Create a geodesic2d navigator context}
\usage{
l_context_add_geodesic2d(navigator, ...)
}
\arguments{
\item{navigator}{navigator handle object}

\item{...}{arguments passed on to modify context states}
}
\value{
context handle
}
\description{
Geodesic2d maps every location on the graph as an orthogonal
  projection of the data onto a two-dimensional subspace. The nodes then
  represent the sub-space spanned by a pair of variates and the edges either
  a 3d- or 4d-transition of one scatterplot into another, depending on how
  many variates the two nodes connected by the edge share (see Hurley and
  Oldford 2011). The geodesic2d context inherits from the context2d context.

Contexts are in more detail explained in the webmanual accessible with 
\code{\link{l_help}}. Please read the section on context by running 
\code{l_help("learn_R_display_graph.html#contexts")}.
}
\seealso{
\code{\link{l_info_states}}, \code{\link{l_context_ids}}, 
  \code{\link{l_context_add_context2d}}, 
  \code{\link{l_context_add_slicing2d}}, \code{\link{l_context_getLabel}}, 
  \code{\link{l_context_relabel}}
}
