% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_bind.R
\name{l_bind_canvas_get}
\alias{l_bind_canvas_get}
\title{Get the event pattern and callback Tcl code of a canvas binding}
\usage{
l_bind_canvas_get(widget, id)
}
\arguments{
\item{widget}{widget path as a string or as an object handle}

\item{id}{canvas binding id}
}
\value{
Character vector of length two. First element is the event pattern,
  the second element is the Tcl callback code.
}
\description{
This function returns the registered event pattern and the Tcl
  callback code that the Tcl interpreter evaluates after a event occurs that
  machtches the event pattern.
}
\details{
Bindings, callbacks, and binding substitutions are described in detail in
loon's documentation webpage, i.e. run \code{l_help("learn_R_bind")}
}
\examples{
# binding for when plot is resized 
p <- l_plot(iris[,1:2], color=iris$Species)

printSize <- function(p) {
    size <- l_size(p)
    cat(paste('Size of widget ', p, ' is: ',
              size[1], 'x', size[2], ' pixels\\n', sep=''))    
}

l_bind_canvas(p, event='<Configure>', function(W) {printSize(W)})

id <- l_bind_canvas_ids(p)
id

l_bind_canvas_get(p, id)
}
\seealso{
\code{\link{l_bind_canvas}}, \code{\link{l_bind_canvas_ids}},
  \code{\link{l_bind_canvas_delete}}, \code{\link{l_bind_canvas_reorder}}
}
