% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/investNoise-method.R
\docType{methods}
\name{investNoise}
\alias{investNoise}
\title{Quality control for time course profiles}
\usage{
investNoise(data, time, sampleID, log, numCores)
}
\arguments{
\item{data}{\code{data.frame} or \code{matrix} containing the samples as rows and features as columns}

\item{time}{\code{numeric} vector containing the sample time point information.}

\item{sampleID}{\code{character}, \code{numeric} or \code{factor} vector containing information about the unique identity of each sample}

\item{log}{\code{logical} indicating log transformation of the data. Default value is TRUE}

\item{numCores}{alternative \code{numeric} value indicating the number of CPU cores to be used for parallelization. Default value is automatically estimated.}
}
\value{
investNoise returns an object of class \code{noise} containing the following components:
\item{name}{\code{character} the colnames or the index.}
\item{RT}{\code{numeric} the time to molecule sd ratio of each trajectory.} 
\item{RI}{\code{numeric} the individual to molecule sd ratio of each trajectory.}
\item{propMissing}{\code{numeric} Proportion of missing values for each trajectory. }
\item{foldChange}{\code{numeric} the maximum absolute fold change (either for log transformed data max(time)-min(time) or not log transformed data max(time)/min(time)) observed between the mean of any two time points. }
}
\description{
Function to calculate filter ratios of trajectories.
}
\details{
investNoise calculates filter ratios R_T and R_I based on the time, individual and overall standard deviation as proposed by Straube \emph{et al.}  2015.
}
\examples{
\dontrun{
data(kidneySimTimeGroup)
G1 <- kidneySimTimeGroup$group=="G1"
noiseTest <-investNoise(data=kidneySimTimeGroup$data[G1,],time=kidneySimTimeGroup$time[G1],
            sampleID=kidneySimTimeGroup$sampleID[G1])
summary(noiseTest)
plot(noiseTest,colorBy="propMissing")}
}
\references{
Straube J., Gorse D., Huang B.E., Le Cao K.-A. (2015).  \emph{A linear mixed model spline framework for analyzing time course 'omics' data} PLOSONE, 10(8), e0134540.
}
\seealso{
\code{\link{summary.noise}}, \code{\link{plot.noise}}, \code{\link{filterNoise}}
}

