% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{methods}
\name{lmmsDE}
\encoding{latin1}
\alias{factorOrcharacterOrnumeric,missingOrcharacter,missingOrcharacter,missingOrcharacter,}
\alias{lmmsDE}
\alias{lmmsDE,matrixOrframe,numeric,factorOrcharacterOrnumeric,}
\alias{lmmsDE,matrixOrframe,numeric,factorOrcharacterOrnumeric,factorOrcharacterOrnumeric,missingOrcharacter,missingOrcharacter,missingOrcharacter,missingOrnumeric,missingOrnumeric-method}
\alias{missingOrnumeric,missingOrnumeric-method}
\title{Differential expression analysis using linear mixed effect model splines.}
\usage{
lmmsDE(data, time, sampleID, group, type,
experiment, basis, knots, numCores)


  \S4method{lmmsDE}{matrixOrframe,numeric,factorOrcharacterOrnumeric,factorOrcharacterOrnumeric,missingOrcharacter,missingOrcharacter,missingOrcharacter,missingOrnumeric,missingOrnumeric}(data,
  time, sampleID, group, type, experiment, basis, knots, numCores)
}
\arguments{
\item{data}{\code{data.frame} or \code{matrix} containing the samples as rows and features as columns}

\item{time}{\code{numeric} vector containing the sample time point information.}

\item{sampleID}{\code{character}, \code{numeric} or \code{factor} vector containing information about the unique identity of each sample}

\item{group}{\code{character}, \code{numeric} or \code{factor} vector containing information about the group (or class) of each sample}

\item{type}{\code{character} indicating what type of analysis is to be performed. Options are \code{"time"} to identify differential expression over time, \code{"group"} to identify profiles with different baseline levels (intercepts), and \code{"time*group"} an interaction between these two . Use \code{"all"} to calculate all three types.}

\item{experiment}{\code{character} describing the experiment performed. \code{"timecourse"} for replicated experiments with less variation in individual expression values (e.g. model organism, cell culture), \code{"longitudinal1"} for different intercepts and \code{"longitudinal2"} for different intercepts and slopes.}

\item{basis}{\code{character} string. What type of basis to use, matching one of \code{"cubic"} smoothing spline as defined by Verbyla \emph{et al.} 1999, \code{"p-spline"} Durb\'an \emph{et al.} 2005 or a \code{"cubic p-spline"}.}

\item{knots}{can take an integer value corresponding to the number of knots for the chosen basis or by default calculated as  in Ruppert 2002. Not in use for the 'cubic' smoothing spline basis.}

\item{numCores}{alternative \code{numeric} value indicating the number of CPU cores to be used for parallelization. Default value is automatically estimated.}
}
\value{
lmmsDE returns an object of class \code{lmmsde} containing the following components:
\item{DE}{\code{data.frame} returning p-values and adjusted p-values using Benjamini-Hochberg correction for multiple testing of the differential expression testing over time, group or their interaction.}
\item{modelTime}{a \code{list} of class \code{\link{lme}}, containing the models for every feature modelling the time effect.}
\item{modelGroup}{a \code{list} of class \code{\link{lme}}, containing the models for every feature modelling group effect. }
\item{modelTimeGroup}{a \code{list} of class \code{\link{lme}}, containing the models for every feature modelling time and group interaction effect. }
\item{type}{an object of class \code{character}, describing the test performed either time, group, time*group or all. }
\item{experiment}{an object of class \code{character} describing the model used to perform differential expression analysis.}
}
\description{
Function to fit a linear mixed effect model splines to perform differential expression analysis. The \code{\link{lmmsDE}} function fits LMM models with either a \code{cubic}, \code{p-spline} or \code{cubic p-spline} basis and compares the models to the null models. The type of basis to use is specified with the \code{basis} argument.
}
\details{
lmmsDE extends the LMMS modelling framework to permit tests between groups, across time, and for interactions between the two.
Suppose we have \eqn{R} different groups of individuals, with \eqn{h_i} denoting the group for each individual \eqn{i}.
Further we define \eqn{h_{ir}} to be the indicator for the \eqn{r^{th}} group, that is, \eqn{h_{ir}=1} if \eqn{h_i=r} and 0 otherwise.
The mean curve for each group \eqn{f_{h_i}} in the full LMMSDE \code{experiment}="timecourse" is given by:
\deqn{f_{h_i}(t_{ij})= \beta_0+ \beta_1 t_{ij} + \sum\limits_{k=1}^{K}u_k(t_{ij}-\kappa_k)_+ }
\deqn{+\sum\limits_{r=2}^{R}h_{ir}(\alpha_{0r} + \alpha_{1r}t_{ij}) + \sum\limits_{r=2}^{R} h_{ir}{ \sum\limits_{k=1}^{K}v_{rk}(t_{ij}-\kappa_k)_+}.}
Here \eqn{\mathbf{\alpha_0}={\alpha_{0r}}} are the differences between the intercepts between each group and the first group; \eqn{\mathbf{\alpha_1}={\alpha_{1r}}} are the differences in slope between each group and the first group; and \eqn{v_{rk}} are the differences in spline coefficients between each group and the first group.
We can use this model to test the effects of time, group and interactions between the two.
For a single group (\code{type}="time"), all \eqn{h_{ir}=0}, and time effects will be detected if the null hypothesis \eqn{\beta_1=0} is rejected.
To detect differences between groups (\code{type}="group"), we set \eqn{\mathbf{\alpha_1}=0}, and test the null hypotheses \eqn{\mathbf{\alpha_0=0}}.
Finally, including all parameters allows us to test for time * group interactions (\code{type}="time*group"), by permitting different slopes in different groups and different intercepts.
For \code{experiment}="longitudinal1" we include subject-specific random effects and assume them to be parallel to the mean curve. Finally, for \code{experiment}="longitudinal2" we assume subject-specific random effects to be straight lines and assuming independence between the random intercept and slope, so the covariance matrix for the random effects \eqn{\Sigma} is diagonal.
In each case we compare the model fit of the expanded model with the respective null model using the function \code{\link{anova}}.
}
\examples{
\dontrun{
data(kidneySimTimeGroup)
lmmsDEtest <-lmmsDE(data=kidneySimTimeGroup$data,time=kidneySimTimeGroup$time,
              sampleID=kidneySimTimeGroup$sampleID,group=kidneySimTimeGroup$group)
summary(lmmsDEtest)}
}
\references{
Durbn, M., Harezlak, J., Wand, M. P., & Carroll, R. J. (2005). \emph{Simple fitting of subject-specific curves for longitudinal data.} Statistics in medicine, 24(8), 1153-67.

Ruppert D. (2002). \emph{Selecting the number of knots for penalized splines.} Journal of Computational and Graphical Statistics 11, 735-757

Verbyla, A. P. Cullis, B. R., & Kenward, M. G. (1999). \emph{The analysis of designed experiments and longitudinal data by using smoothing splines.} Appl.Statist.(1999), 18(3), 269-311.
}
\seealso{
\code{\link{summary.lmmsde}}, \code{\link{plot.lmmsde}}
}

