% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lineqAGP.R
\name{lineqAGPSys}
\alias{lineqAGPSys}
\title{Linear Systems of Inequalities for \code{"lineqAGP"} Models}
\usage{
lineqAGPSys(m = nrow(A), constrType = c("boundedness", "monotonicity",
  "convexity", "linear", "none"), l = -Inf, u = Inf, A = diag(m),
  d = length(m), lineqSysType = "twosides",
  constrIdx = seq(length(m)), rmInf = TRUE)
}
\arguments{
\item{m}{the number of linear inequality constraints.}

\item{constrType}{a character string corresponding to the type of the inequality constraint.
Options: "boundedness", "monotonicity", "convexity", "linear"}

\item{l}{the value (or vector) with the lower bound.}

\item{u}{the value (or vector) with the upper bound.}

\item{A}{a matrix containing the structure of the linear equations.}

\item{d}{the value with the input dimension.}

\item{lineqSysType}{a character string corresponding to the type of the
linear system. Options: \code{twosides}, \code{oneside} (see \code{\link{bounds2lineqSys}} for more details).}

\item{constrIdx}{for d > 1, a logical vector with the indices of active constrained dimensions.}

\item{rmInf}{If \code{TRUE}, inactive constraints are removed
(e.g. \eqn{-\infty \leq x \leq \infty}{-Inf \le x \le Inf}).}
}
\value{
A list with the linear system of inequalities: \code{list(A,l,u)} (\code{twosides}) or \code{list(M,g)} (\code{oneside}).
}
\description{
Build the linear system of inequalities for \code{"lineqAGP"} models.
}
\section{Comments}{

This function could change in future versions for more types of inequality
constraints in higher dimensions.
}

\examples{
linSys1 <- lineqAGPSys(m = 5, constrType = "boundedness", l = 0, u = 1, lineqSysType = "twosides")
linSys1
linSys2 <- lineqAGPSys(m = 5, constrType = "boundedness", l = 0, u = 1, lineqSysType = "oneside")
linSys2

}
\references{
Lopez-Lopera, A. F., Bachoc, F., Durrande, N., and Roustant, O. (2017),
"Finite-dimensional Gaussian approximation with linear inequality constraints".
\emph{ArXiv e-prints}
\href{https://arxiv.org/abs/1710.07453}{[link]}
}
\seealso{
\code{\link{bounds2lineqSys}}
}
\author{
A. F. Lopez-Lopera.
}
