/* libsoc - Library to handle standardised output files
 * Copyright (C) 2015 Rikard Nordgren
 * 
 * This file was autogenerated and should not be edited
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * his library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */
#include <string.h>
#include <libxml/xmlwriter.h>
#include <pharmml/common_types.h>
#include <pharmml/string.h>
#include <so/PrecisionPopulationEstimates.h>
#include <so/private/PrecisionPopulationEstimates.h>

so_PrecisionPopulationEstimates *so_PrecisionPopulationEstimates_new()
{
	so_PrecisionPopulationEstimates *object = calloc(sizeof(so_PrecisionPopulationEstimates), 1);
	if (object) {
		object->reference_count = 1;
	}

	return object;
}

so_PrecisionPopulationEstimates *so_PrecisionPopulationEstimates_copy(so_PrecisionPopulationEstimates *self)
{
	so_PrecisionPopulationEstimates *dest = so_PrecisionPopulationEstimates_new();
	if (dest) {
		if (self->MLE) {
			dest->MLE = so_MLE_copy(self->MLE);
			if (!dest->MLE) {
				so_PrecisionPopulationEstimates_free(dest);
				return NULL;
			}
		}
		if (self->Bayesian) {
			dest->Bayesian = so_Bayesian_PPE_copy(self->Bayesian);
			if (!dest->Bayesian) {
				so_PrecisionPopulationEstimates_free(dest);
				return NULL;
			}
		}
		if (self->OtherMethod) {
			dest->OtherMethod = so_OtherMethod_PPE_copy(self->OtherMethod);
			if (!dest->OtherMethod) {
				so_PrecisionPopulationEstimates_free(dest);
				return NULL;
			}
		}
	}

	return dest;
}

void so_PrecisionPopulationEstimates_free(so_PrecisionPopulationEstimates *self)
{
	if (self) {
		so_MLE_unref(self->MLE);
		so_Bayesian_PPE_unref(self->Bayesian);
		so_OtherMethod_PPE_unref(self->OtherMethod);
		free(self);
	}
}

void so_PrecisionPopulationEstimates_ref(so_PrecisionPopulationEstimates *self)
{
	self->reference_count++;
}

void so_PrecisionPopulationEstimates_unref(so_PrecisionPopulationEstimates *self)
{
	if (self) {
		self->reference_count--;
		if (!self->reference_count) {
			so_PrecisionPopulationEstimates_free(self);
		}
	}
}

so_MLE *so_PrecisionPopulationEstimates_get_MLE(so_PrecisionPopulationEstimates *self)
{
	return self->MLE;
}

so_Bayesian_PPE *so_PrecisionPopulationEstimates_get_Bayesian(so_PrecisionPopulationEstimates *self)
{
	return self->Bayesian;
}

so_OtherMethod_PPE *so_PrecisionPopulationEstimates_get_OtherMethod(so_PrecisionPopulationEstimates *self)
{
	return self->OtherMethod;
}

void so_PrecisionPopulationEstimates_set_MLE(so_PrecisionPopulationEstimates *self, so_MLE *value)
{
	so_MLE_unref(self->MLE);
	self->MLE = value;
}

void so_PrecisionPopulationEstimates_set_Bayesian(so_PrecisionPopulationEstimates *self, so_Bayesian_PPE *value)
{
	so_Bayesian_PPE_unref(self->Bayesian);
	self->Bayesian = value;
}

void so_PrecisionPopulationEstimates_set_OtherMethod(so_PrecisionPopulationEstimates *self, so_OtherMethod_PPE *value)
{
	so_OtherMethod_PPE_unref(self->OtherMethod);
	self->OtherMethod = value;
}

so_MLE *so_PrecisionPopulationEstimates_create_MLE(so_PrecisionPopulationEstimates *self)
{
	so_MLE *obj = so_MLE_new();
	if (obj) {
		self->MLE = obj;
	}
	return obj;
}

so_Bayesian_PPE *so_PrecisionPopulationEstimates_create_Bayesian(so_PrecisionPopulationEstimates *self)
{
	so_Bayesian_PPE *obj = so_Bayesian_PPE_new();
	if (obj) {
		self->Bayesian = obj;
	}
	return obj;
}

so_OtherMethod_PPE *so_PrecisionPopulationEstimates_create_OtherMethod(so_PrecisionPopulationEstimates *self)
{
	so_OtherMethod_PPE *obj = so_OtherMethod_PPE_new();
	if (obj) {
		self->OtherMethod = obj;
	}
	return obj;
}

int so_PrecisionPopulationEstimates_xml(so_PrecisionPopulationEstimates *self, xmlTextWriterPtr writer)
{
	int rc;
	if (self->MLE || self->Bayesian || self->OtherMethod) {
		rc = xmlTextWriterStartElement(writer, BAD_CAST "PrecisionPopulationEstimates");
		if (rc < 0) return 1;
		if (self->MLE) {
			rc = so_MLE_xml(self->MLE, writer);
			if (rc != 0) return rc;
		}
		if (self->Bayesian) {
			rc = so_Bayesian_PPE_xml(self->Bayesian, writer);
			if (rc != 0) return rc;
		}
		if (self->OtherMethod) {
			rc = so_OtherMethod_PPE_xml(self->OtherMethod, writer);
			if (rc != 0) return rc;
		}
		rc = xmlTextWriterEndElement(writer);
		if (rc < 0) return 1;
	}
	return 0;
}

int so_PrecisionPopulationEstimates_start_element(so_PrecisionPopulationEstimates *self, const char *localname, int nb_attributes, const char **attributes)
{
	if (self->in_MLE) {
		int fail = so_MLE_start_element(self->MLE, localname, nb_attributes, attributes);
		if (fail) {
			return fail;
		}
	} else if (self->in_Bayesian) {
		int fail = so_Bayesian_PPE_start_element(self->Bayesian, localname, nb_attributes, attributes);
		if (fail) {
			return fail;
		}
	} else if (self->in_OtherMethod) {
		int fail = so_OtherMethod_PPE_start_element(self->OtherMethod, localname, nb_attributes, attributes);
		if (fail) {
			return fail;
		}
	} else if (strcmp(localname, "MLE") == 0) {
		so_MLE *MLE = so_PrecisionPopulationEstimates_create_MLE(self);
		if (!MLE) {
			return 1;
		}
		self->in_MLE = 1;
	} else if (strcmp(localname, "Bayesian") == 0) {
		so_Bayesian_PPE *Bayesian = so_PrecisionPopulationEstimates_create_Bayesian(self);
		if (!Bayesian) {
			return 1;
		}
		self->in_Bayesian = 1;
	} else if (strcmp(localname, "OtherMethod") == 0) {
		so_OtherMethod_PPE *OtherMethod = so_PrecisionPopulationEstimates_create_OtherMethod(self);
		if (!OtherMethod) {
			return 1;
		}
		self->in_OtherMethod = 1;
	}
	return 0;
}

void so_PrecisionPopulationEstimates_end_element(so_PrecisionPopulationEstimates *self, const char *localname)
{
	if (strcmp(localname, "MLE") == 0 && self->in_MLE) {
		self->in_MLE = 0;
	} else if (strcmp(localname, "Bayesian") == 0 && self->in_Bayesian) {
		self->in_Bayesian = 0;
	} else if (strcmp(localname, "OtherMethod") == 0 && self->in_OtherMethod) {
		self->in_OtherMethod = 0;
	} else if (self->in_MLE) {
		so_MLE_end_element(self->MLE, localname);
	} else if (self->in_Bayesian) {
		so_Bayesian_PPE_end_element(self->Bayesian, localname);
	} else if (self->in_OtherMethod) {
		so_OtherMethod_PPE_end_element(self->OtherMethod, localname);
	}
}

int so_PrecisionPopulationEstimates_characters(so_PrecisionPopulationEstimates *self, const char *ch, int len)
{
	if (self->in_MLE) {
		int fail = so_MLE_characters(self->MLE, ch, len);
		if (fail) return 1;
	} else if (self->in_Bayesian) {
		int fail = so_Bayesian_PPE_characters(self->Bayesian, ch, len);
		if (fail) return 1;
	} else if (self->in_OtherMethod) {
		int fail = so_OtherMethod_PPE_characters(self->OtherMethod, ch, len);
		if (fail) return 1;
	}
	return 0;
}
