% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lgcpStructures.R
\name{lgcpInits}
\alias{lgcpInits}
\title{lgcpInits function}
\usage{
lgcpInits(etainit = NULL, betainit = NULL)
}
\arguments{
\item{etainit}{a vector, the initial value of eta to use}

\item{betainit}{a vector, the initial value of beta to use, this vector must have names the same as the variable names in the formula in use, and in the same order.}
}
\value{
an object of class lgcpInits used in the MCMC routine.
}
\description{
A function to declare initial values for a run of the MCMC routine. If specified, the MCMC algorithm will calibrate the proposal
density using these as provisional estimates of the parameters.
}
\details{
It is not necessary to supply intial values to the MCMC routine, by default the functions lgcpPredictSpatialPlusPars, lgcpPredictAggregateSpatialPlusPars,
lgcpPredictSpatioTemporalPlusPars and lgcpPredictMultitypeSpatialPlusPars will initialise the MCMC as follows. For eta, if no initial value is
specified then the initial value of eta in the MCMC run will be the prior mean. For beta, if no initial value is specified then
the initial value of beta in the MCMC run will be estimated from an overdispersed Poisson fit to the cell counts, ignoring spatial correlation. The user cannot
specify an initial value of Y (or equivalently Gamma), as a sensible value is chosen by the MCMC function.

A secondary function of specifying initial values is to help design the MCMC proposal matrix, which is based on these initial estimates.
}
\examples{
\dontrun{INITS <- lgcpInits(etainit=log(c(sqrt(1.5),275)), betainit=NULL)}
}
\seealso{
\link{minimum.contrast}, \link{minimum.contrast.spatiotemporal}, \link{chooseCellwidth}, \link{getpolyol}, \link{guessinterp}, \link{getZmat},
\link{addTemporalCovariates}, \link{lgcpPrior}, \link{CovFunction},
\link{lgcpPredictSpatialPlusPars}, \link{lgcpPredictAggregateSpatialPlusPars}, \link{lgcpPredictSpatioTemporalPlusPars},
\link{lgcpPredictMultitypeSpatialPlusPars}
}
