\name{GPdrv2}
\alias{GPdrv2}
\title{GPdrv2 function}
\usage{
  GPdrv2(GP, prior, Z, Zt, eta, beta, nis, cellarea,
    spatial, gradtrunc, fftgrid, covfunction, d,
    eps = 1e-06)
}
\arguments{
  \item{GP}{an object of class GPrealisation}

  \item{prior}{priors for the model}

  \item{Z}{design matirix on the FFT grid}

  \item{Zt}{transpose of the design matrix}

  \item{eta}{vector of parameters, eta}

  \item{beta}{vector of parameters, beta}

  \item{nis}{cell counts on the extended grid}

  \item{cellarea}{the cell area}

  \item{spatial}{the poisson offset}

  \item{gradtrunc}{gradient truncation parameter}

  \item{fftgrid}{an object of class FFTgrid}

  \item{covfunction}{the choice of covariance function, see
  ?CovFunction}

  \item{d}{matrix of toral distances}

  \item{eps}{the finite difference step size}
}
\value{
  first and second derivatives of the log target at the
  specified paramters Y, eta and beta
}
\description{
  A function to compute the second derivative of the log
  target with respect to the paramters of the latent field.
  Not intended for general purpose use.
}

