\name{mult}
\alias{mult}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Callback-based Multiplication of Matrices}
\description{
    Perform a custom multiplication of the matrices \code{x} and \code{y} by using the callback function \code{f}.
}
\usage{
mult(x, y, f, ...)
}
\arguments{
    \item{x}{
        A first matrix. The number of columns must match with the number of rows of the \code{y}
        matrix.
    }
    \item{y}{
        A second matrix. The number of rows must match with the number of columns of the \code{x}
        matrix.
    }
    \item{f}{
        A function to be applied to the matrices in order to compute the multiplication.
        It must accept at least two arguments.
    }
    \item{...}{
        Additional arguments that are passed to the function \code{f}.
    }
}
\details{
    For a matrix \code{x} of size \eqn{(u,v)} and a matrix \code{y} of size \eqn{(v,w)}, \code{mult}
    calls the function \code{f} \eqn{uw}-times to create a resulting matrix of size \eqn{(u,w)}.
    Each \eqn{(i,j)}-th element of the resulting matrix is obtained from a call of the function
    \code{f} with \code{x}'s \eqn{i}-th row and \code{y}'s \eqn{j}-th column passed as its arguments.
}
\value{
    A matrix with \eqn{v} rows and \eqn{w} columns, where \eqn{v} is the number of rows of \code{x}
    and \eqn{w} is the number of columns of \code{y}.
}
%\references{
%}
\author{
    Michal Burda
}
%\note{
%%  ~~further notes~~
%}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
  \code{\link{compose}}
}

\examples{
    x <- matrix(runif(24, -100, 100), ncol=6)
    y <- matrix(runif(18, -100, 100), nrow=6)

    mult(x, y, function(xx, yy) sum(xx * yy)) # the same as "x %*% y"
}

% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ models }
\keyword{ robust }
\keyword{ multivariate }
