% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/key-other.R
\name{key_specialty}
\alias{key_specialty}
\alias{key_sequence}
\alias{key_bins}
\title{Speciality keys}
\usage{
key_sequence(n = 15)

key_bins(even.steps = FALSE, show.limits = NULL)
}
\arguments{
\item{n}{A positive \verb{<integer[1]>} giving the number of colours to use for a
gradient.}

\item{even.steps}{A \verb{<logical[1]>} indicating whether the size of bins
should be displayed as equal (\code{TRUE}) or proportional to their length in
data space (\code{FALSE}).}

\item{show.limits}{A \verb{<logical[1]>} stating whether the limits of the scale
should be shown with labels and ticks (\code{TRUE}) or remain hidden (\code{FALSE}).
Note that breaks coinciding with limits are shown regardless of this
setting. The default, \code{NULL}, consults the scale's \code{show.limits} setting
or defaults to \code{FALSE}.}
}
\value{
For \code{key_sequence()} a function.
}
\description{
These functions are helper functions for working with keys in guides. The
functions described here are not widely applicable and may only apply
to a small subset of guides. As such, it is fine to adjust the arguments
of a speciality key, but swapping types is ill-advised.
\itemize{
\item \code{key_sequence()} is a function factory whose functions create a regularly
spaced sequence between the limits of a scale. It is used in colour bar
guides.
\item \code{key_bins()} is a function factory whose function create a binned key
given the breaks in the scale. It is used in colour steps guides.
}
}
\examples{
# An example scale
template <- scale_fill_viridis_c(limits = c(0, 10), breaks = c(2, 4, 6, 8))

# Retrieving colourbar and colourstep keys
key_sequence()(template)
key_bins()(template)
}
\seealso{
Other keys: 
\code{\link{key_group}},
\code{\link{key_range}},
\code{\link{key_segments}},
\code{\link{key_standard}}
}
\concept{keys}
