% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Module.R
\name{Module}
\alias{Module}
\title{Module}
\description{
A LaminDB module containing one or more registries.
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{name}}{(\code{character(1)})\cr
Get the name of the module.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Module-new}{\code{Module$new()}}
\item \href{#method-Module-get_registries}{\code{Module$get_registries()}}
\item \href{#method-Module-get_registry}{\code{Module$get_registry()}}
\item \href{#method-Module-get_registry_names}{\code{Module$get_registry_names()}}
\item \href{#method-Module-print}{\code{Module$print()}}
\item \href{#method-Module-to_string}{\code{Module$to_string()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Module-new"></a>}}
\if{latex}{\out{\hypertarget{method-Module-new}{}}}
\subsection{Method \code{new()}}{
Creates an instance of this R6 class. This class should not be instantiated directly,
but rather by connecting to a LaminDB instance using the \code{\link[=connect]{connect()}} function.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Module$new(instance, api, module_name, module_schema)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{instance}}{The instance the module belongs to.}

\item{\code{api}}{The API for the instance.}

\item{\code{module_name}}{The name of the module.}

\item{\code{module_schema}}{The schema of the module.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Module-get_registries"></a>}}
\if{latex}{\out{\hypertarget{method-Module-get_registries}{}}}
\subsection{Method \code{get_registries()}}{
Get the registries in the module.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Module$get_registries()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list of \link{Registry} objects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Module-get_registry"></a>}}
\if{latex}{\out{\hypertarget{method-Module-get_registry}{}}}
\subsection{Method \code{get_registry()}}{
Get a registry by name.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Module$get_registry(registry_name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{registry_name}}{The name of the registry.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \link{Registry} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Module-get_registry_names"></a>}}
\if{latex}{\out{\hypertarget{method-Module-get_registry_names}{}}}
\subsection{Method \code{get_registry_names()}}{
Get the names of the registries in the module. E.g. \code{c("User", "Artifact")}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Module$get_registry_names()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A character vector of registry names.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Module-print"></a>}}
\if{latex}{\out{\hypertarget{method-Module-print}{}}}
\subsection{Method \code{print()}}{
Print a \code{Module}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Module$print(style = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{style}}{Logical, whether the output is styled using ANSI codes.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Module-to_string"></a>}}
\if{latex}{\out{\hypertarget{method-Module-to_string}{}}}
\subsection{Method \code{to_string()}}{
Create a string representation of a \code{Module}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Module$to_string(style = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{style}}{Logical, whether the output is styled using ANSI codes}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{cli::cli_ansi_string} if \code{style = TRUE} or a character vector
}
}
}
