\name{kobeSS3}
\alias{kobeSS3}
\title{Reads SS3 assessment results and returns stock and harvest rate relative  to MSY reference points}
\usage{
  kobeSS3(object,nrows=-1,thin=1,
          what=c("sims","trks","pts","smry","wrms")[1], prob=c(0.75,0.5,0.25),pts=NULL,yrs=NULL,nwrms=10)
}
\arguments{
  \item{object}{character: derived posteriors file with MCMC runs.}

  \item{nrows}{numeric; if -ve reads all rowss, otherwise takes the 1st nrows from the file.}
  
  \item{thin}{numeric; thinning rate for chain.}
  
  \item{what}{character; specifies the form of data returned.}
  
  \item{prob}{numeric; probabilities with values in [0,1] for percentiles returned if \code{what["trks"]} selected.}

  \item{pts}{numeric; year(s) for points if \code{what["pts"]} selected.}

  \item{yrs}{numeric; year(s) for historical estimates.}

  \item{nwrms}{numeric; number of trajectories sampled at random to return if \code{what["wrms"]} selected.}

}
\description{
  Reads in derived posteriors from text files generated by SS3, i.e. assessment and projection and returns time series or summaries of B:BMSY and F:FMSY \code{what} specifies how data are returned, i.e. \code{sims} bootstraps for all years; \code{trks} percentiles given by \code{prob};
\code{pts} selected year(s) given by \code{pts}; \code{smRY} probabilities of being in the kobe quadrants and; \code{wrms} bootstraps selected at random. 
If of length 1 then a data.frame is returned, if >1 then a list of data.frames.
}
\examples{

\dontrun{
kobeSS3(...)
}

}
\seealso{
  \code{\link{kobeAspic}},\code{\link{kobe2box}},\code{\link{kobeSS3}}
  }

