% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simple_slopes_analysis_logistic.R
\name{simple_slopes_analysis_logistic}
\alias{simple_slopes_analysis_logistic}
\title{Simple slopes analysis with logistic regression analyses}
\usage{
simple_slopes_analysis_logistic(
  data = NULL,
  iv_name = NULL,
  dv_name = NULL,
  mod_name = NULL,
  round_b = 2,
  round_se = 2,
  round_z = 2,
  round_p = 3,
  focal_values = NULL
)
}
\arguments{
\item{data}{a data object (a data frame or a data.table)}

\item{iv_name}{name of the independent variable (IV)}

\item{dv_name}{name of the dependent variable (DV)}

\item{mod_name}{name of the moderator variable (MOD)}

\item{round_b}{number of decimal places to which to round
coefficients from the regression analysis (default = 2)}

\item{round_se}{number of decimal places to which to round
standard error values from the regression analysis (default = 2)}

\item{round_z}{number of decimal places to which to round
t statistics from the regression analysis (default = 2)}

\item{round_p}{number of decimal places to which to round
p values from the regression analysis (default = 2)}

\item{focal_values}{this input will be used only in cases where IV
is continuous. In such cases, what are the focal values of the IV
at which to estimate the effect of MOD on DV? By default, values
corresponding to the mean of IV +/-1 SD will be used.}
}
\description{
Conduct a simple slopes analysis with logistic regression analyses,
typically to probe a two-way interaction when the dependent variable
is binary.
}
\examples{
\donttest{
simple_slopes_analysis_logistic(
data = mtcars, iv_name = "vs", dv_name = "am", mod_name = "hp")
simple_slopes_analysis_logistic(
data = mtcars, iv_name = "disp", dv_name = "am", mod_name = "hp")
}
}
