% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pretty_round_r.R
\name{pretty_round_r}
\alias{pretty_round_r}
\title{Pretty round r}
\usage{
pretty_round_r(r = NULL, round_digits_after_decimal = 2)
}
\arguments{
\item{r}{a (vector of) correlation coefficient(s)}

\item{round_digits_after_decimal}{how many digits after the decimal
point should the p-value be rounded to? (default = 2)}
}
\value{
the output will be a character vector of correlation coefficient(s).
}
\description{
Round correlation coefficients in APA style (7th Ed.)
}
\examples{
pretty_round_r(r = -0.123)
pretty_round_r(c(-0.12345, 0.45678), round_digits_after_decimal = 3)
pretty_round_r(c(-0.12, 0.45), round_digits_after_decimal = 4)
}
