% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_cols_to_numeric.R
\name{convert_cols_to_numeric}
\alias{convert_cols_to_numeric}
\title{Convert columns to numeric}
\usage{
convert_cols_to_numeric(
  data = NULL,
  classes = "character",
  warn_accuracy_loss = TRUE,
  print_summary = TRUE,
  silent = FALSE
)
}
\arguments{
\item{data}{a data object (a data frame or a data.table)}

\item{classes}{a character vector specifying classes of columns
that will be converted. For example, if \code{classes = "character"},
all columns of the class "character" will be converted--if they can be
converted. The current version of the function only supports converting
character columns to numeric.}

\item{warn_accuracy_loss}{logical. whether to warn the user if
converting character to numeric leads to loss of accuracy.
(default = TRUE)}

\item{print_summary}{If \code{print_summary = TRUE}, a summary of
converted columns will printed. (default = TRUE)}

\item{silent}{If \code{silent = FALSE}, a message regarding conversion
for a data.frame will be printed. If \code{silent = TRUE}, this message
will be suppressed. By default, \code{silent = FALSE}.}
}
\description{
Check whether each column in a data.table can be converted to numeric,
and if so, convert every such column.
}
\examples{
data_frame_1 <- data.frame(a = c("1", "2"), b = c("1", "b"), c = 1:2)
convert_cols_to_numeric(data = data_frame_1)
data_table_1 <- data.table::data.table(
a = c("1", "2"), b = c("1", "b"), c = 1:2)
convert_cols_to_numeric(data = data_table_1)
}
