% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_proportion_diff.R
\name{prop_diff_test}
\alias{prop_diff_test}
\alias{a_test_proportion_diff}
\alias{s_test_proportion_diff}
\title{Difference test for two proportions}
\usage{
a_test_proportion_diff(
  df,
  .var,
  ref_path,
  .spl_context,
  ...,
  .stats = NULL,
  .formats = NULL,
  .labels = NULL,
  .indent_mods = NULL
)

s_test_proportion_diff(
  df,
  .var,
  .ref_group,
  .in_ref_col,
  variables = list(strata = NULL),
  method = c("chisq", "fisher", "cmh"),
  alternative = c("two.sided", "less", "greater")
)
}
\arguments{
\item{df}{(\code{data.frame})\cr data set containing all analysis variables.}

\item{.var}{(\code{string})\cr single variable name that is passed by \code{rtables} when requested
by a statistics function.}

\item{ref_path}{(\code{character})\cr global reference group specification, see \code{\link[=get_ref_info]{get_ref_info()}}.}

\item{.spl_context}{(\code{data.frame})\cr gives information about ancestor split states
that is passed by \code{rtables}.}

\item{...}{additional arguments for the lower level functions.}

\item{.stats}{(\code{character})\cr statistics to select for the table.}

\item{.formats}{(named \code{character} or \code{list})\cr formats for the statistics. See Details in \code{analyze_vars} for more
information on the \code{'auto'} setting.}

\item{.labels}{(named \code{character})\cr labels for the statistics (without indent).}

\item{.indent_mods}{(named \code{integer})\cr indent modifiers for the labels. Defaults to 0, which corresponds to the
unmodified default behavior. Can be negative.}

\item{.ref_group}{(\code{data.frame} or \code{vector})\cr the data corresponding to the reference group.}

\item{.in_ref_col}{(\code{logical})\cr \code{TRUE} when working with the reference level, \code{FALSE} otherwise.}

\item{variables}{(named \code{list} of \code{string})\cr list of additional analysis variables.}

\item{method}{(\code{string})\cr one of \code{chisq}, \code{cmh}, \code{fisher}; specifies the test used
to calculate the p-value.}

\item{alternative}{(\code{string})\cr whether \code{two.sided}, or one-sided \code{less} or \code{greater} p-value
should be displayed.}
}
\value{
\itemize{
\item \code{a_test_proportion_diff()} returns the corresponding list with formatted \code{\link[rtables:CellValue]{rtables::CellValue()}}.
}

\itemize{
\item \code{s_test_proportion_diff()} returns a named \code{list} with a single item \code{pval} with an attribute \code{label}
describing the method used. The p-value tests the null hypothesis that proportions in two groups are the same.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

The analysis function \code{\link[=a_test_proportion_diff]{a_test_proportion_diff()}} can be used to create a layout element to test
the difference between two proportions. The primary analysis variable, \code{vars}, indicates whether a
response has occurred for each record. See the \code{method} parameter for options of methods to use
to calculate the p-value. Additionally, a stratification variable can be supplied via the \code{strata}
element of the \code{variables} argument. The argument \code{alternative} specifies the direction of the
alternative hypothesis.
}
\section{Functions}{
\itemize{
\item \code{a_test_proportion_diff()}: Formatted analysis function which is used as \code{afun}

\item \code{s_test_proportion_diff()}: Statistics function which tests the difference between two proportions.

}}
\note{
These functions have been forked from the \code{tern} package. Additional features are:
\itemize{
\item Additional \code{alternative} argument for the sidedness of the test.
\item Additional \code{ref_path} argument for flexible reference column path specification.
}
}
\examples{
dta <- data.frame(
  rsp = sample(c(TRUE, FALSE), 100, TRUE),
  grp = factor(rep(c("A", "B"), each = 50)),
  strata = factor(rep(c("V", "W", "X", "Y", "Z"), each = 20))
)

l <- basic_table() |>
  split_cols_by(var = "grp") |>
  analyze(
    vars = "rsp",
    afun = a_test_proportion_diff,
    show_labels = "hidden",
    extra_args = list(
      method = "cmh",
      variables = list(strata = "strata"),
      ref_path = c("grp", "B")
    )
  )

build_table(l, df = dta)

}
\seealso{
\link{h_prop_diff_test}
}
\keyword{internal}
