% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/references.R
\name{jst_get_references}
\alias{jst_get_references}
\title{Extract all references}
\usage{
jst_get_references(file_path, parse_refs = F)
}
\arguments{
\item{file_path}{The path to the \code{.xml}-file from which references should be
extracted.}

\item{parse_refs}{Should references be parsed, if available?}
}
\value{
A \code{tibble} with the following columns:
\itemize{
\item \code{file_name}: the identifier for the article the references come from.
\item \code{ref_title}: the title of the references sections.
\item \code{ref_authors}: a string of authors. Several authors are separated with \code{;}.
\item \code{ref_editors}: a string of editors, if available.
\item \code{ref_collab}: a field that may contain information on the authors, if authors
are not available.
\item \code{ref_item_title}: the title of the cited entry. For books this is often
empty, with the title being in \code{ref_source}.
\item \code{ref_year}: a year, often the article's publication year, but not always.
\item \code{ref_source}: the source of the cited entry. For books often the title of the
book, for articles the publisher of the journal.
\item \code{ref_volume}: the volume of the journal article.
\item \code{ref_first_page}: the first page of the article/chapter.
\item \code{ref_last_page}: the last page of the article/chapter.
\item \code{ref_publisher}: For books the publisher, for articles often missing.
\item \code{ref_publication_type}: Known types: \code{book}, \code{journal}, \code{web}, \code{other}.
\item \code{ref_unparsed}: The full references entry in unparsed form.
}
}
\description{
This function extracts the content of \code{ref-list} from the \code{xml}-file.
}
\details{
This content may contain references or endnotes, depending on how the article
used citations. Since references are currently not fully supported by DfR,
there is no comprehensive documentation on the different variants. \code{jstor}
therefore extracts the content of \code{ref-list} exactly as it appears in the
data. Because of this, there might be other content present than references.

In order to get all available information on citation data, you might need to
combine \code{jst_get_references()} with \code{jst_get_footnotes()}.

For newer \code{xml}-files, there would be the option to extract single elements
like authors, title or date of the source, but this is not yet implemented.

In general, the implementation is not as fast as \code{jst_get_article()} -
articles with many references slow the process down.
}
\examples{
jst_get_references(jst_example("article_with_references.xml"))

# import parsed references
jst_get_references(
  jst_example("parsed_references.xml"),
  parse_refs = TRUE
) 
}
