% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dot.R
\name{dot}
\alias{dot}
\alias{dot_}
\alias{dotstr}
\alias{dotstr_}
\title{dot and related functions}
\usage{
dot(.data)

dot_(.data, dots = ".")

dotstr(.data, ...)

dotstr_(.data, ..., .dots)
}
\arguments{
\item{.data}{input. This can be JSON input, or an object of class
\code{jqr} that has JSON and query params combined, which is passed
from function to function when using the jqr DSL.}

\item{dots}{dots}

\item{...}{Comma separated list of unquoted variable names}

\item{.dots}{Used to work around non-standard evaluation}
}
\description{
dot and related functions
}
\examples{
str <- '[{"name":"JSON", "good":true}, {"name":"XML", "good":false}]'
str \%>\% dot
str \%>\% index \%>\% dotstr(name)
'{"foo": 5, "bar": 8}' \%>\% dot
'{"foo": 5, "bar": 8}' \%>\% dotstr(foo)
'{"foo": {"bar": 8}}' \%>\% dotstr(foo.bar)
}

