% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Predictaplsm.R
\name{Predictaplsm}
\alias{Predictaplsm}
\title{Predict from the APLSM}
\usage{
Predictaplsm(model, type)
}
\arguments{
\item{model}{object of class the APLSM}

\item{type}{character indicating the types of model. It could be "DD", distance by distance model, "DV", distance by vector model,
"VV", vector by vector model}
}
\value{
list containing:
 \itemize{
 \item \code{est.P.i} (\code{N} x \code{N}) matrix containing the predicted probabilities of an edge
 \item \code{est.P.ia} (\code{N} x \code{M}) matrix containing the predicted probabilities of an edge
 }
}
\description{
This function allows you to obtain the posterior edge values based on the APLSM
}
\examples{
attach(french)
b=aplsm(Niter=3,Y.i, Y.ia,D=2, type="DD")
Predictaplsm(b,"DD")
}
