% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jackalope-package.R
\docType{package}
\name{jackalope-package}
\alias{jackalope}
\alias{jackalope-package}
\title{jackalope: A Swift, Versatile Phylogenomic and High-Throughput Sequencing Simulator}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

Simply and efficiently simulates (i) variants from reference genomes and (ii) reads from both Illumina \url{https://www.illumina.com/} and Pacific Biosciences (PacBio) \url{https://www.pacb.com/} platforms. It can either read reference genomes from FASTA files or simulate new ones. Genomic variants can be simulated using summary statistics, phylogenies, Variant Call Format (VCF) files, and coalescent simulations—the latter of which can include selection, recombination, and demographic fluctuations. 'jackalope' can simulate single, paired-end, or mate-pair Illumina reads, as well as PacBio reads. These simulations include sequencing errors, mapping qualities, multiplexing, and optical/polymerase chain reaction (PCR) duplicates. Simulating Illumina sequencing is based on ART by Huang et al. (2012) \doi{10.1093/bioinformatics/btr708}. PacBio sequencing simulation is based on SimLoRD by Stöcker et al. (2016) \doi{10.1093/bioinformatics/btw286}. All outputs can be written to standard file formats.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/lucasnell/jackalope}
  \item Report bugs at \url{https://github.com/lucasnell/jackalope/issues}
}

}
\author{
\strong{Maintainer}: Lucas A. Nell \email{lucnell@gmail.com} (\href{https://orcid.org/0000-0003-3209-0517}{ORCID}) [copyright holder]

}
\keyword{internal}
