% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lbl_helpers.R
\name{lbl_add}
\alias{lbl_add}
\alias{lbl_add_vals}
\title{Add labels for unlabelled values}
\usage{
lbl_add(x, ...)

lbl_add_vals(x, labeller = as.character, vals = NULL)
}
\arguments{
\item{x}{A \code{\link[haven:labelled]{labelled}} vector}

\item{...}{Arbitrary number of label placeholders created with \code{\link[=lbl]{lbl()}}
indicating the value/label pairs to add.}

\item{labeller}{A function that takes values being added as an argument and
returns the labels to associate with those values. By default, uses the
values themselves after converting to character.}

\item{vals}{Vector of values to be labelled. If \code{NULL}, labels all unlabelled
values that exist in the data.}
}
\value{
A \code{\link[haven:labelled]{labelled}} vector
}
\description{
Add labels for values that don't already have them in a
\code{\link[haven:labelled]{labelled}} vector.
}
\examples{
x <- haven::labelled(
  c(100, 200, 105, 990, 999, 230),
  c(`Unknown` = 990, NIU = 999)
)

# Add new labels manually
lbl_add(
  x,
  lbl(100, "$100"),
  lbl(105, "$105"),
  lbl(200, "$200"),
  lbl(230, "$230")
)

# Add labels for all unlabelled values
lbl_add_vals(x)

# Update label names while adding
lbl_add_vals(x, labeller = ~ paste0("$", .))

# Add labels for select values
lbl_add_vals(x, vals = c(100, 200))
}
\seealso{
Other lbl_helpers: 
\code{\link{lbl}()},
\code{\link{lbl_clean}()},
\code{\link{lbl_define}()},
\code{\link{lbl_na_if}()},
\code{\link{lbl_relabel}()},
\code{\link{zap_ipums_attributes}()}
}
\concept{lbl_helpers}
