% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_multivariate.R
\name{is_multivariate}
\alias{is_multivariate}
\title{Checks if an object stems from a multivariate response model}
\usage{
is_multivariate(x)
}
\arguments{
\item{x}{A model object, or an object returned by a function from this package.}
}
\value{
A logical, \code{TRUE} if either \code{x} is a model object and is
   a multivariate response model, or \code{TRUE} if a return value from a
   function of \pkg{insight} is from a multivariate response model.
}
\description{
Small helper that checks if a model is a multivariate response
  model, i.e. a model with multiple outcomes.
}
\examples{
\dontrun{
library(rstanarm)
data("pbcLong")
model <- stan_mvmer(
  formula = list(
    logBili ~ year + (1 | id),
    albumin ~ sex + year + (year | id)
  ),
  data = pbcLong,
  chains = 1, cores = 1, seed = 12345, iter = 1000
)

f <- find_formula(model)
is_multivariate(model)
is_multivariate(f)
}
}
