% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flex.R
\name{flexPage}
\alias{flexPage}
\title{Create a page a with CSS flexbox layout}
\usage{
flexPage(..., title = NULL, fill_page = TRUE, dependency = bootstrapLib())
}
\arguments{
\item{...}{Elements to include within the page}

\item{title}{The browser window title (defaults to the host URL of the page)}

\item{fill_page}{Flag to tell the page if it should adjust the page to
adjust and fill the browser window size}

\item{dependency}{The set of web dependencies. This value can be a
htmlDependency, for example the shiny bootstrap one (the default)
or a tagList with diferent dependencies}
}
\value{
A UI definition that can be passed to the [shinyUI] function.
}
\description{
Create a page a with CSS flexbox layout
}
\note{
See
  \url{https://css-tricks.com/snippets/css/a-guide-to-flexbox/}
  for additional details on using css flexbox
}
\examples{
if (interactive()) {
library(imola)
flexPage(
  title = "A flex page",
  div(class = "area-1"),
  div(class = "area-2"),
  div(class = "area-3")
)
}

}
\seealso{
[flexPanel()]
}
\concept{flex functions}
