% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/public.R
\name{pubRepApply}
\alias{pubRepApply}
\alias{publicRepertoireApply}
\title{Apply transformations to public repertoires}
\usage{
pubRepApply(.pr1, .pr2, .fun = function(x) log10(x[1])/log10(x[2]))
}
\arguments{
\item{.pr1}{First public repertoire.}

\item{.pr2}{Second public repertoire.}

\item{.fun}{A function to apply to pairs of frequencies of same clonotypes from "pr1" and "pr2".
By default - \code{log(X) / log(Y)} where \code{X,Y} - frequencies of the same clonotype,
found in both public repertoires.}
}
\value{
Work in progress.
}
\description{
Work In Progress
}
\examples{
data(immdata)
immdata$data <- lapply(immdata$data, head, 2000)
pr <- pubRep(immdata$data, .verbose = FALSE)
pr1 <- pubRepFilter(pr, immdata$meta, .by = c(Status = "MS"))
pr2 <- pubRepFilter(pr, immdata$meta, .by = c(Status = "C"))
prapp <- pubRepApply(pr1, pr2)
head(prapp)
}
\concept{pubrep}
