\name{iid.test}
\alias{iid.test}
\title{iid test}
\description{
Test for whether a variable is independent and identically distributed (iid). Used in \code{\link{daily.station.records}}.

Reference:

Benestad, R.E., 2003: How often can we expect a record-event? Climate Research. 23, 3-13 (pdf)

Benestad, R.E., 2004: Record values, nonstationarity tests and extreme value distributions, Global and Planetary Change, vol 44, p. 11-26

The papers are available in the pdf format from \url{http://regclim.met.no/results_iii_artref.html}.

Note, gaps of missing data (NA) can bias the results and produce an under-count. The sign of non-iid behaviour is when the 'forward' analysis indicated higher number of record-events than the confidence region and the backward analysis gives lower than the confidence region.

Version 0.7: Added a test checking for dependencies based on an expected number from a binomial distribution and given the probability p1(n) = 1/n. This test is applied to the parallel series for one respective time (realisation), and is then repeated for all observation times. The check uses \code{\link{qbinom}} to compute a theoretical 95\% confidence interval, and a number outside this range is marked with red in the 'ball diagram' (first plot). \code{\link{pbinom}} is used to estimate the p-value for the 
}
\usage{
iid.test(Y,plot=TRUE,Monte.Carlo=TRUE,N.test=200,reverse.plot.reverse=TRUE)
}
\arguments{
    \item{Y}{A data matrix or a vector.}
    \item{plot}{Flag: plot the diagnostics.}
    \item{Monte.Carlo}{Flag: for estimating confidence limits.}
    \item{N.test}{Number of Monre-Carlo runs.}
    \item{reverse.plot.reverse}{TRUE: plots reverse from right to left, else left to right.}.
}
\value{list: 'record.density' and 'record.density.rev' for the reverse analysis. The variables CI.95, p.val, and i.cluster (and their reverse equivalents '.rev') return the estimated 95\% conf. int, p-value, and the location of the clusters (binomial).}
\author{R.E. Benestad}}
\examples{
dat <- rnorm(100*30)
dim(dat) <- c(100,30)
iid.test(dat)
}
\keyword{manip}

