% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LazyFST-class.R
\name{convert-fst}
\alias{convert-fst}
\alias{convert_fst_to_hdf5}
\alias{convert_fst_to_csv}
\title{Convert 'FST' files to other formats}
\usage{
convert_fst_to_hdf5(fst_path, hdf5_path, exclude_names = NULL)

convert_fst_to_csv(fst_path, csv_path, exclude_names = NULL)
}
\arguments{
\item{fst_path}{path to 'FST' file}

\item{hdf5_path}{path to 'HDF5' file; if file exists before the conversion,
the file will be erased first. Please make sure the files are backed up.}

\item{exclude_names}{table names to exclude}

\item{csv_path}{path to 'CSV' file; if file exists before the conversion,
the file will be erased first. Please make sure the files are backed up.}
}
\value{
\code{convert_fst_to_hdf5} will return a list of data saved to 'HDF5';
\code{convert_fst_to_csv} returns the normalized 'CSV' path.
}
\description{
'HDF5', 'CSV' are common file formats that can be
read into 'Matlab' or 'Python'
}
