% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robert.R
\name{robert}
\alias{robert}
\title{FUNCTION to produce a Robertsonian translocation}
\usage{
robert(dfChrSize, dfMarkPos, chr1, chr2, arm1, arm2)
}
\arguments{
\item{dfChrSize}{name of data.frame of chr. sizes}

\item{dfMarkPos}{name of data.frame of chr marks' positions}

\item{chr1}{name of chr.}

\item{chr2}{name of chr.}

\item{arm1}{arm of \code{chr1} to be included}

\item{arm2}{arm of \code{chr2} to be included}
}
\value{
list
}
\description{
This function reads a data.frame with chr. sizes \code{\link{chrbasicdatamono}} and another with marks' positions,
\code{\link{markposDFs}} and gets as arguments two chr. names and two arms, respectively.

It returns a list with two data.frames. One with the chr. size of the resulting translocation
and another with the marks' positions for the derivative chr.
}
\examples{
data(humChr)
data(humMarkPos)
chrt13q14q<-robert(humChr,humMarkPos,13,14,"q","q")

}
\references{
Robertson, W. R. B. (1916). Chromosome studies. I. Taxonomic relationships shown in the chromosomes of Tettigidae and Acrididae: V-shaped chromosomes and their significance in Acrididae, Locustidae, and Gryllidae: chromosomes and variation. Journal of Morphology, 27(2), 179-331.
}
\keyword{translocation}
