% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sqplot.R
\name{sqplot}
\alias{sqplot}
\title{Plot of Non-constant Solar Quiet Daily Variation}
\usage{
sqplot(x, start = NULL, end = NULL, n.station = NULL,
  graphs.per.page = 2, station.names = NULL, Title = NULL, ...)
}
\arguments{
\item{x}{estimation of solar quite variations from \code{SQ}}

\item{start}{start date of records for magnetic activities. See examples}

\item{end}{end date of records for magnetic activities. See examples}

\item{n.station}{number of studied stations}

\item{graphs.per.page}{how many graphs combined in one plot page. Default number is 2}

\item{station.names}{NULL (indicating no station names) or a vector strings for station names.}

\item{Title}{title of sqplot}

\item{...}{additional arguments}
}
\description{
This function visualizes the estimated non-constant solar quiet daily variation of each station.
Users would define how many graphs to be put into one page, The default set is 2 graphs per page.
}
\details{
This function is used to visualize estimated Sq variation. Specifying the names of each stations would
add station names at y-axis.
}
\examples{
## data sets.

## Colatitude and longitude of geomagnetic observatories.
\dontrun{
coord=matrix(c(124.43, 19.23, 53.77,140.18,68.68,202.00,71.89,293.85),nrow=2,ncol=4)


## Estimation of SI index
index.sample<- SAIndex(record, coord, wf="la8")
si.v<-index.sample$SI


## generate datetime for one week period
start.date="2001-3-1"
end.date="2001-4-30"

## estimation of sq
Sq<- SQ (datasq, si.v=si.v, wf = "la8")

sqplot(Sq, Title="Sq variation", start = start.date, end=end.date, n.station=4,
      graphs.per.page=2, station.names=c("ABG","PHU","TUC","FRD"))
}
}
\seealso{
\code{\link{SQ}}
}

