% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{BIARphikalman}
\alias{BIARphikalman}
\title{Minus Log Likelihood of the BIAR Model}
\usage{
BIARphikalman(phiValues, y1, y2, t, yerr1, yerr2, zeroMean = "TRUE")
}
\arguments{
\item{phiValues}{An array with the parameters of the BIAR model. The elements of the array are, in order, the real (phiR) and the imaginary (phiI) part of the coefficient of BIAR model.}

\item{y1}{Array with the observations of the first time series of the BIAR process.}

\item{y2}{Array with the observations of the second time series of the BIAR process.}

\item{t}{Array with the irregular observational times.}

\item{yerr1}{Array with the measurements error standard deviations of the first time series of the BIAR process.}

\item{yerr2}{Array with the measurements error standard deviations of the second time series of the BIAR process.}

\item{zeroMean}{logical; if true, the array y has zero mean; if false, y has a mean different from zero.}
}
\value{
Value of the negative log likelihood evaluated in phiR and phiI.
}
\description{
This function return the negative log likelihood of the BIAR process given specific values of phiR and phiI
}
\examples{
n=300
set.seed(6714)
st<-gentime(n)
x=BIARsample(n=n,phiR=0.9,phiI=0.3,st=st)
y=x$y
y1=y[1,]
y2=y[2,]
yerr1=rep(0,n)
yerr2=rep(0,n)
BIARphikalman(phiValues=c(0.8,0.2),y1=y1,y2=y2,t=st,yerr1=yerr1,yerr2=yerr2)
}
\references{
\insertRef{Elorrieta_2021}{iAR}
}
\seealso{
\code{\link{gentime}}, \code{\link{BIARsample}}
}
