% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIARkalman.R
\name{BIARkalman}
\alias{BIARkalman}
\title{Maximum Likelihood Estimation of the BIAR Model via Kalman Recursions}
\usage{
BIARkalman(
  y1,
  y2,
  t,
  delta1 = 0,
  delta2 = 0,
  zero.mean = "TRUE",
  niter = 10,
  seed = 1234
)
}
\arguments{
\item{y1}{Array with the observations of the first time series of the BIAR process.}

\item{y2}{Array with the observations of the second time series of the BIAR process.}

\item{t}{Array with the irregular observational times.}

\item{delta1}{Array with the measurements error standard deviations of the first time series of the BIAR process.}

\item{delta2}{Array with the measurements error standard deviations of the second time series of the BIAR process.}

\item{zero.mean}{logical; if true, the array y has zero mean; if false, y has a mean different from zero.}

\item{niter}{Number of iterations in which the function nlminb will be repeated.}

\item{seed}{a single value, interpreted as the seed of the random process.}
}
\value{
A list with the following components:
\itemize{
\item{phiR}{ MLE of the autocorrelation coefficient of BIAR model (phiR).}
\item{phiI}{ MLE of the cross-correlation coefficient of the BIAR model (phiI).}
\item{ll}{ Value of the negative log likelihood evaluated in phiR and phiI.}
}
}
\description{
Maximum Likelihood Estimation of the BIAR model parameters phiR and phiI. The estimation procedure uses the Kalman Filter to find the maximum of the likelihood.
}
\examples{
\donttest{
n=80
set.seed(6714)
st<-gentime(n)
x=BIARsample(n=n,phiR=0.9,phiI=0,st=st,rho=0)
y=x$y
y1=y/apply(y,1,sd)
biar=BIARkalman(y1=y1[1,],y2=y1[2,],t=st,delta1 = rep(0,length(y[1,])),
delta2=rep(0,length(y[1,])))
biar
}
}
\references{
\insertRef{Elorrieta_2021}{iAR}
}
\seealso{
\code{\link{gentime}}, \code{\link{BIARsample}}, \code{\link{BIARphikalman}}
}
