% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hill_taxa.R
\name{hill_taxa}
\alias{hill_taxa}
\title{Taxonomic diversity through Hill Numbers}
\usage{
hill_taxa(comm, q = 0, MARGIN = 1, base = exp(1))
}
\arguments{
\item{comm}{A data frame of vegtation data. Sites as rows, species as columns.}

\item{q}{Hill number, \code{q} = 0 (default) to get species richness,
\code{q} = 1 to get shannon entropy, \code{q} = 2 will give inverse Simpson.}

\item{MARGIN}{default is 1, if sites are columns, set \code{MARGIN} to 2.}

\item{base}{default is \code{exp(1)}, the base of log.}
}
\value{
A named vector, diversity values for each site in the comm.
}
\description{
Calculate taxonomic diversity for each site (alpha diversity).
}
\examples{
dummy = FD::dummy
hill_taxa(comm = dummy$abun, q = 0)
# same as: vegan::specnumber(dummy$abun)
hill_taxa(comm = dummy$abun, q = 1)
# same as: exp(vegan::diversity(x = dummy$abun, index = 'shannon'))
hill_taxa(comm = dummy$abun, q = 2)
# same as: vegan::diversity(x = dummy$abun, index = 'invsimpson')
hill_taxa(comm = dummy$abun, q = 0.999)

}
\references{
Chao, Anne, Chun-Huo Chiu, and Lou Jost. Unifying Species Diversity, Phylogenetic Diversity, Functional Diversity, and Related Similarity and Differentiation Measures Through Hill Numbers. Annual Review of Ecology, Evolution, and Systematics 45, no. 1 (2014): 297–324. <doi:10.1146/annurev-ecolsys-120213-091540>.

Jost, Lou. Entropy and diversity. Oikos 113, no. 2 (2006): 363-375. <doi:10.1111/j.2006.0030-1299.14714.x>.
}
