# [highcharter](http://jkunst.com/highcharter/)

R wrapper for highcharts

[![travis-status](https://api.travis-ci.org/jbkunst/highcharter.svg)](https://travis-ci.org/jbkunst/highcharter)
[![codecov.io](https://codecov.io/github/jbkunst/highcharter/coverage.svg?branch=master)](https://codecov.io/github/jbkunst/highcharter?branch=master)
[![version](http://www.r-pkg.org/badges/version/highcharter)](http://www.r-pkg.org/pkg/highcharter)
[![downloads](http://cranlogs.r-pkg.org/badges/highcharter)](http://www.r-pkg.org/pkg/highcharter)
[![issues](http://issuestats.com/github/jbkunst/highcharter/badge/issue?style=flat)](http://issuestats.com/github/jbkunst/highcharter)
[![pr](http://issuestats.com/github/jbkunst/highcharter/badge/pr?style=flat)](http://issuestats.com/github/jbkunst/highcharter)

It is a *must* know how `highcharts` api works to *take advantage* of this package. I invited you to look some [demos](http://www.highcharts.com/demo) charts and explore chart types, syntax and all what highcharts can do.

## Resources

- Official package website: http://jkunst.com/highcharter/.
- Replicating- Highcharts Demos: https://cran.rstudio.com/web/packages/highcharter/vignettes/replicating-highcharts-demos.html
- CRAN site https://cran.r-project.org/web/packages/highcharter/.
- Shiny demo code https://github.com/jbkunst/shiny-apps/tree/master/highcharter.

## Why highcharter?

- [Various](http://jkunst.com/highcharter/) chart type with the same style (scatters, time series, heatmaps, treemap, bar charts, more coming soon).
- [Piping styling](http://jkunst.com/highcharter/).
- Support [Highstock charts](http://jkunst.com/highcharter/highstock.html). You can create a candlestick charts in 2 lines of code. Support `xts` objects from the quantmod package.
- Support [Highmaps charts](http://jkunst.com/highcharter/highmaps.html). It's easy to create choropleths or add information in geojson format.
- Chart various R object with [one function](http://jkunst.com/highcharter/hchart.html). With `hchart(x)` you can chart: numeric, histograms, character, factors, ts, mts, xts, stl, ohlc, acf, forecast, dist classes.
- [Themes](http://jkunst.com/highcharter/themes.html): Add themes, merge themes or create your own.
- [Plugins](http://jkunst.com/highcharter/plugins.html): Drag points, fontawesome, url-pattern.
- <3 to Highcharts.com

## Licence 

Highcharter is licensed under the MIT License. However, highcharts.com is licensed under 
their own terms. Highcharts is free for personal or non profit projects under the 
[Creative Commons Attribution-NonCommercial 3.0 License](http://creativecommons.org/licenses/by-nc/3.0/).

## Code of Conduct

Please note that this project is released with a [Contributor Code of Conduct](CONDUCT.md). By participating in this project you agree to abide by its terms.

