% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmixlm.R
\name{rmixlm}
\alias{rmixlm}
\title{Random data generation from the mixture of Gaussian linear (Markov-switching) models for hhsmm model}
\usage{
rmixlm(j, model, covar, ...)
}
\arguments{
\item{j}{a specified state}

\item{model}{a \code{\link{hhsmmspec}} model}

\item{covar}{either a function which generates the covariate vector or a list containing the following items:
\itemize{
\item \code{mean} the mean vector of covariates (to be generated from multivariate normal distribution)
\item \code{cov} the variance-covariance matrix of covariates (to be generated from multivariate normal distribution)
}}

\item{...}{additional arguments of the \code{covar} function}
}
\value{
a random matrix of observations from mixture of Gaussian linear (Markov-switching) models,
in which the first columns are associated with the responses
and the last columns are associated with the covariates
}
\description{
Generates vectors of covariate and response observations
from mixture of Gaussian linear (Markov-switching) models in a specified state and using the
parameters of a specified model
}
\examples{
J <- 3
initial <- c(1, 0, 0)
semi <- rep(FALSE, 3)
P <- matrix(c(0.5, 0.2, 0.3, 0.2, 0.5, 0.3, 0.1, 0.4, 0.5), nrow = J, 
byrow = TRUE)
par <- list(intercept = list(3, list(-10, -1), 14),
coefficient = list(-1, list(1, 5), -7),
csigma = list(1.2, list(2.3, 3.4), 1.1),
mix.p = list(1, c(0.4, 0.6), 1))
model <- hhsmmspec(init = initial, transition = P, parms.emis = par,
dens.emis = dmixlm, semi = semi)

#use the covar as the list of mean and 
#variance of the normal distribution 

train1 <- simulate(model, nsim = c(20, 30, 42, 50), seed = 1234, 
remission = rmixlm, covar = list(mean = 0, cov = 1))
plot(train1$x[,1] ~ train1$x[,2], col = train1$s, pch = 16, 
xlab = "x", ylab = "y")

#use the covar as the runif function 
#to generate one covariate from standard uniform distribution 

train2 <- simulate(model, nsim = c(20, 30, 42, 50), seed = 1234, 
remission = rmixlm, covar = runif, 1)
plot(train2$x[,1] ~ train2$x[,2], col = train2$s, pch = 16, 
xlab = "x", ylab = "y")

}
\references{
Kim, C. J., Piger, J. and Startz, R. (2008). Estimation of Markov
regime-switching regression models with endogenous switching.
Journal of Econometrics, 143(2), 263-273.
}
\author{
Morteza Amini, \email{morteza.amini@ut.ac.ir}
}
