% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raddreg.R
\name{raddreg}
\alias{raddreg}
\title{Random data generation from the Gaussian additive (Markov-switching) model for hhsmm model}
\usage{
raddreg(j, model, covar, ...)
}
\arguments{
\item{j}{a specified state}

\item{model}{a \code{\link{hhsmmspec}} model}

\item{covar}{either a function which generates the covariate vector or a list containing the following items:
\itemize{
\item \code{mean} the mean vector of covariates (to be generated from multivariate normal distribution)
\item \code{cov} the variance-covariance matrix of covariates (to be generated from multivariate normal distribution)
}}

\item{...}{additional arguments of the \code{covar} function}
}
\value{
a random matrix of observations from Gaussian additive (Markov-switching) model,
in which the first columns are associated with the responses
and the last columns are associated with the covariates
}
\description{
Generates vectors of covariate and response observations
from the Gaussian additive (Markov-switching) model, using B-Splines in a specified state and using the
parameters of a specified model
}
\examples{
J <- 3
initial <- c(1, 0, 0)
semi <- rep(FALSE, 3)
P <- matrix(c(0.5, 0.2, 0.3, 0.2, 0.5, 0.3, 0.1, 0.4, 0.5), nrow = J, 
byrow = TRUE)
par <- list(intercept = list(-21, -83, 33),
coef = list(array(c(1, 8, 52, 27, 38), dim = c(5, 1, 1)),  
array(c(99, 87, 94, 77, 50), dim = c(5, 1, 1)), 
array(c(-1, -8, -40, -22, -28), dim = c(5, 1, 1))),
sigma = list(0.2, 0.4, 0.1))
model <- hhsmmspec(init = initial, transition = P, parms.emis = par,
dens.emis = dnorm_additive_reg, semi = semi)
train <- simulate(model, nsim = 70, seed = 1234, 
remission = raddreg, covar = list(mean = 0, cov = 1))
plot(train$x[, 1] ~ train$x[, 2], col = train$s, pch = 16, 
xlab = "x", ylab = "y")

}
\references{
Langrock, R., Adam, T., Leos-Barajas, V.,
Mews, S., Miller, D. L., and Papastamatiou, Y. P. (2018).
Spline-based nonparametric inference in general state-switching models.
Statistica Neerlandica, 72(3), 179-200.
}
\author{
Morteza Amini, \email{morteza.amini@ut.ac.ir}
}
