% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mstep-mix-lm.R
\name{mixlm_mstep}
\alias{mixlm_mstep}
\title{the M step function of the EM algorithm}
\usage{
mixlm_mstep(x, wt1, wt2, resp.ind = 1)
}
\arguments{
\item{x}{the observation matrix including responses and covariates}

\item{wt1}{the state probabilities matrix (number of observations
times number of states)}

\item{wt2}{the mixture components probabilities list (of length
nstate) of matrices (number of observations times number of
mixture components)}

\item{resp.ind}{a vector of the column numbers of \code{x} which contain response variables.
The default is 1, which means that the first column of \code{x} is the univariate
response variable}
}
\value{
list of emission (mixture of Gaussian linear regression models) parameters:
(\code{intercept}, \code{coefficients}, \code{csigma} (conditional covariance) and \code{mix.p})
}
\description{
The M step function of the EM algorithm for the mixture
of Gaussian linear (Markov-switching) regressions as the emission distribution using the
responses and covariates matrices and the estimated weight vectors
}
\examples{
J <- 3
initial <- c(1, 0, 0)
semi <- rep(FALSE, 3)
P <- matrix(c(0.5, 0.2, 0.3, 0.2, 0.5, 0.3, 0.1, 0.4, 0.5), nrow = J, 
byrow = TRUE)
par <- list(intercept = list(3, list(-10, -1), 14),
coefficient = list(-1, list(1, 5), -7),
csigma = list(1.2, list(2.3, 3.4), 1.1),
mix.p = list(1, c(0.4, 0.6), 1))
model <- hhsmmspec(init = initial, transition = P, parms.emis = par,
dens.emis = dmixlm, semi = semi)
train <- simulate(model, nsim = c(20, 30, 42, 50), seed = 1234, 
remission = rmixlm, covar = list(mean = 0, cov = 1))
clus = initial_cluster(train = train, nstate = 3, nmix = c(1, 2, 1),
ltr = FALSE, final.absorb = FALSE, verbose = TRUE, regress = TRUE)
initmodel = initialize_model(clus = clus ,mstep = mixlm_mstep,
dens.emission = dmixlm, sojourn = NULL, semi = rep(FALSE, 3),
M = max(train$N),verbose = TRUE)
fit1 = hhsmmfit(x = train, model = initmodel, mstep = mixlm_mstep,
M = max(train$N))
plot(train$x[, 1] ~ train$x[, 2], col = train$s, pch = 16, 
xlab = "x", ylab = "y")
abline(fit1$model$parms.emission$intercept[[1]],
fit1$model$parms.emission$coefficient[[1]], col = 1)
abline(fit1$model$parms.emission$intercept[[2]][[1]],
fit1$model$parms.emission$coefficient[[2]][[1]], col = 2)
abline(fit1$model$parms.emission$intercept[[2]][[2]],
fit1$model$parms.emission$coefficient[[2]][[2]], col = 2)
abline(fit1$model$parms.emission$intercept[[3]],
fit1$model$parms.emission$coefficient[[3]], col = 3)

}
\references{
Kim, C. J., Piger, J. and Startz, R. (2008). Estimation of Markov
regime-switching regression models with endogenous switching.
Journal of Econometrics, 143(2), 263-273.
}
\author{
Morteza Amini, \email{morteza.amini@ut.ac.ir}
}
