% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClassMethods.R
\name{summary.dsc_obj}
\alias{summary.dsc_obj}
\title{Summary for 'dsc' object}
\usage{
\method{summary}{dsc_obj}(object, eval_period = NULL, ...)
}
\arguments{
\item{object}{An object of type 'dsc'.}

\item{eval_period}{(Optional) A vector of indices to specify the evaluation period. Defaults to the entire period after burn-in.}

\item{...}{Additional arguments to be consistent with the S3 print() function.}
}
\value{
A list containing:
\describe{
\item{MSE}{A list with the mean squared error (MSE) and squared errors (SE).}
\item{ACRPS}{A list with the average continuous ranked probability score (ACRPS) and CRPS values.}
\item{APLL}{A list with the average predictive log-likelihood (APLL) and predictive log-likelihood (PLL) values.}
\item{Plots}{A list of ggplot objects for visualizing the tuning parameters and selected CFMs.}
}
}
\description{
This function plots the evolution of the tuning parameters for a 'dsc' object and returns basic performance metrics.
}
\examples{
\donttest{

# See example for tvc().

}
}
\references{
Gneiting, T., Raftery, A. E., Westveld, A. H., and Goldman, T. (2005):
Calibrated Probabilistic Forecasting Using Ensemble Model Output Statistics and Minimum CRPS Estimation.
\emph{Monthly Weather Review}, 133: 1098–1118.

Jordan, A., Krueger, F., and Lerch, S. (2019):
"Evaluating Probabilistic Forecasts with scoringRules."
\emph{Journal of Statistical Software}, 90(12): 1-37.
}
