% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simHCE.R
\name{simHCE}
\alias{simHCE}
\title{Simulate \code{hce} object with given event rates of time-to-event outcomes, mean and SD of the continuous outcome by treatment group}
\usage{
simHCE(
  n,
  n0 = n,
  TTE_A,
  TTE_P,
  CM_A,
  CM_P,
  CSD_A = 1,
  CSD_P = 1,
  fixedfy = 1,
  yeardays = 360,
  pat = 100,
  seed = NULL
)
}
\arguments{
\item{n}{sample size in the active treatment group.}

\item{n0}{sample size in the placebo group.}

\item{TTE_A}{event rates per year in the active group for the time-to-event outcomes.}

\item{TTE_P}{event rates per year in the placebo group for the time-to-event outcomes. Should have the same length as TTE_A.}

\item{CM_A}{mean value for the continuous outcome of the active group.}

\item{CM_P}{mean value for the continuous outcome of the placebo group.}

\item{CSD_A}{standard deviation for the continuous outcome of the active group.}

\item{CSD_P}{standard deviation for the continuous outcome of the placebo group.}

\item{fixedfy}{length of follow-up in years.}

\item{yeardays}{number of days in a year.}

\item{pat}{scale of provided event rates (per pat-years).}

\item{seed}{the seed for generating random numbers.}
}
\value{
an object of class hce containing the following columns:
\itemize{
\item ID subject identifier.
\item TRTP planned treatment group - "A" for active, "P" for Placebo.
\item GROUP type of the outcome, either "TTE" for time-to-event outcomes or "C" for continuous.
Only one continuous outcome is possible, but no restriction on the number of "TTE" outcomes.
\item GROUPN order of outcomes in \code{GROUP}, with a higher value signifying a better outcome.
\item AVALT the timing of the time-to-event outcomes.
\item AVAL0 numeric values of the continuous outcome and the timing of "TTE" outcomes.
\item AVAL analysis values derived as \code{AVAL0 + GROUPN}. For the continuous outcome the values of \code{AVAL0} are shifted to start always from 0.
\item seed the seed of the random sample. If not specified in \code{seed} argument will be selected based on system time.
\item PADY primary analysis day, the length of fixed follow-up in days calculated as \code{yeardays} multiplied by \code{fixedfy}.
}
}
\description{
Simulate \code{hce} object with given event rates of time-to-event outcomes, mean and SD of the continuous outcome by treatment group
}
\examples{
# Example 1
Rates_A <- c(1.72, 1.74, 0.58, 1.5, 1)
Rates_P <- c(2.47, 2.24, 2.9, 4, 6)
dat <- simHCE(n = 2500, TTE_A = Rates_A, TTE_P = Rates_P,
CM_A = -3, CM_P = -6, CSD_A = 16, CSD_P = 15, fixedfy = 3)
head(dat)

# Example 2
Rates_A <- c(5, 7)
Rates_P <- c(7, 10)
dat <- simHCE(n = 1000, n0 = 500, TTE_A = Rates_A, TTE_P = Rates_P, CM_A = 2, CM_P = 0)
summaryWO(dat)
}
\seealso{
\code{\link[=hce]{hce()}}, \code{\link[=as_hce]{as_hce()}} for the helper a coerce function to hce objects.
}
