% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zap_label.R
\name{zap_label}
\alias{zap_label}
\title{Zap label}
\usage{
zap_label(x)
}
\arguments{
\item{x}{A vector or data frame}
}
\description{
Removes label, leaving unlabelled vectors as is. Use this if you want to
simply drop all \code{label} attributes from a data frame.

This function removes variable labels; use \code{\link[=zap_labels]{zap_labels()}} to remove value
labels.
}
\examples{
x1 <- labelled(1:5, c(good = 1, bad = 5))
x1
zap_label(x1)

x2 <- labelled_spss(c(1:4, 9), c(good = 1, bad = 5), na_values = 9)
x2
zap_label(x2)

# zap_label also works with data frames
df <- tibble::tibble(x1, x2)
df
zap_label(df)
}
\seealso{
Other zappers: \code{\link{zap_empty}},
  \code{\link{zap_formats}}, \code{\link{zap_labels}},
  \code{\link{zap_widths}}
}
\concept{zappers}
