% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labelled.R
\name{labelled}
\alias{labelled}
\alias{is.labelled}
\title{Create a labelled vector.}
\usage{
labelled(x, labels, label = NULL)

is.labelled(x)
}
\arguments{
\item{x}{A vector to label. Must be either numeric (integer or double) or
character.}

\item{labels}{A named vector. The vector should be the same type as
\code{x}. Unlike factors, labels don't need to be exhaustive: only a fraction
of the values might be labelled.}

\item{label}{A short, human-readable description of the vector.}
}
\description{
A labelled vector is a common data structure in other statistical
environments, allowing you to assign text labels to specific values.
This class makes it possible to import such labelled vectors in to R
without loss of fidelity. This class provides few methods, as I
expect you'll coerce to a standard R class (e.g. a \code{\link[=factor]{factor()}})
soon after importing.
}
\examples{
s1 <- labelled(c("M", "M", "F"), c(Male = "M", Female = "F"))
s2 <- labelled(c(1, 1, 2), c(Male = 1, Female = 2))
s3 <- labelled(c(1, 1, 2), c(Male = 1, Female = 2),
               label="Assigned sex at birth")

# Unfortunately it's not possible to make as.factor work for labelled objects
# so instead use as_factor. This works for all types of labelled vectors.
as_factor(s1)
as_factor(s1, labels = "values")
as_factor(s2)

# Other statistical software supports multiple types of missing values
s3 <- labelled(c("M", "M", "F", "X", "N/A"),
  c(Male = "M", Female = "F", Refused = "X", "Not applicable" = "N/A")
)
s3
as_factor(s3)

# Often when you have a partially labelled numeric vector, labelled values
# are special types of missing. Use zap_labels to replace labels with missing
# values
x <- labelled(c(1, 2, 1, 2, 10, 9), c(Unknown = 9, Refused = 10))
zap_labels(x)
}
