% Generated by roxygen2 (4.0.2): do not edit by hand
\name{h2o.download_pojo}
\alias{h2o.download_pojo}
\title{Download the Scoring POJO (Plain Old Java Object) of a H2O Model}
\usage{
h2o.download_pojo(model, path = "", getjar = TRUE)
}
\arguments{
\item{model}{An H2OModel}

\item{path}{The path to the directory to store the POJO (no trailing slash). If "", then print to
to console. The file name will be a compilable java file name.}

\item{getjar}{Whether to also download the h2o-genmodel.jar file needed to compile the POJO}
}
\value{
If path is "", then pretty print the POJO to the console.
        Otherwise save it to the specified directory.
}
\description{
Download the Scoring POJO (Plain Old Java Object) of a H2O Model
}
\examples{
\donttest{
library(h2o)
h <- h2o.init(nthreads=-1)
fr <- as.h2o(iris)
my_model <- h2o.gbm(x=1:4, y=5, training_frame=fr)

h2o.download_pojo(my_model)  # print the model to screen
# h2o.download_pojo(my_model, getwd())  # save the POJO and jar file to the current working
#                                         directory, NOT RUN
# h2o.download_pojo(my_model, getwd(), getjar = FALSE )  # save only the POJO to the current
#                                                           working directory, NOT RUN
h2o.download_pojo(my_model, getwd())  # save to the current working directory
}
}

