% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{h2o.kolmogorov_smirnov}
\alias{h2o.kolmogorov_smirnov}
\alias{h2o.kolmogorov_smirnov,H2OModelMetrics-method}
\alias{h2o.kolmogorov_smirnov,H2OModel-method}
\title{Kolmogorov-Smirnov metric for binomial models}
\usage{
h2o.kolmogorov_smirnov(object)

\S4method{h2o.kolmogorov_smirnov}{H2OModelMetrics}(object)

\S4method{h2o.kolmogorov_smirnov}{H2OModel}(object)
}
\arguments{
\item{object}{Either an \linkS4class{H2OModel} object or an
\linkS4class{H2OModelMetrics} object.}
}
\value{
Kolmogorov-Smirnov metric, a number between 0 and 1.
}
\description{
Retrieves a Kolmogorov-Smirnov metric for given binomial model. The number returned is in range between 0 and 1.
K-S metric represents the degree of separation between the positive (1) and negative (0) cumulative distribution
functions. Detailed metrics per each group are to be found in the gains-lift table.
}
\details{
The \linkS4class{H2OModelMetrics} version of this function will only take
\linkS4class{H2OBinomialMetrics} objects.
}
\examples{
\dontrun{
library(h2o)
h2o.init()
data <- h2o.importFile(
path = "https://s3.amazonaws.com/h2o-public-test-data/smalldata/airlines/allyears2k_headers.zip")
model <- h2o.gbm(x = c("Origin", "Distance"), y = "IsDepDelayed", 
                       training_frame = data, ntrees = 1)
h2o.kolmogorov_smirnov(model)
}
}
\seealso{
\code{\link{h2o.gainsLift}} to see detailed K-S metrics per group
}
