% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frame.R
\name{h2o.filterNACols}
\alias{h2o.filterNACols}
\title{Filter NA Columns}
\usage{
h2o.filterNACols(data, frac = 0.2)
}
\arguments{
\item{data}{A dataset to filter on.}

\item{frac}{The threshold of NAs to allow per column (columns >= this threshold are filtered)}
}
\value{
Returns a numeric vector of indexes that pertain to non-NA columns
}
\description{
Filter NA Columns
}
\examples{
\dontrun{
library(h2o)
h2o.init()

frame <- h2o.createFrame(rows = 6, cols = 2,
                         categorical_fraction = 0.0, 
                         missing_fraction = 0.7, 
                         seed = 123)
h2o.filterNACols(frame, frac = 0.5)
h2o.filterNACols(frame, frac = 0.6)
}
}
