% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.R
\name{h2o.exportHDFS}
\alias{h2o.exportHDFS}
\title{Export a Model to HDFS}
\usage{
h2o.exportHDFS(object, path, force = FALSE)
}
\arguments{
\item{object}{an \linkS4class{H2OModel} class object.}

\item{path}{The path to write the model to. Must include the driectory and
filename.}

\item{force}{logical, indicates how to deal with files that already exist.}
}
\description{
Exports an \linkS4class{H2OModel} to HDFS.
}
\examples{
\dontrun{
library(h2o)
h2o.init

f <- "https://s3.amazonaws.com/h2o-public-test-data/smalldata/iris/iris_train.csv"
train <- h2o.importFile(f)
h2o.exportHDFS(train, path = " ", force = FALSE)
}
}
